-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Tempo de geração: 11/11/2025 às 18:07
-- Versão do servidor: 10.4.32-MariaDB
-- Versão do PHP: 8.0.30

-- Criar e selecionar o banco de dados alvo
CREATE DATABASE IF NOT EXISTS `biblioteca1` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `biblioteca1`;

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `biblioteca1`
--

-- --------------------------------------------------------

--
-- Estrutura para tabela `emprestimos`
--

CREATE TABLE `emprestimos` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `livro_id` int(11) NOT NULL,
  `data_emprestimo` timestamp NOT NULL DEFAULT current_timestamp(),
  `data_devolucao_prevista` date NOT NULL,
  `data_devolucao_real` date DEFAULT NULL,
  `status` enum('ativo','devolvido','atrasado','pendente_pagamento') DEFAULT 'ativo',
  `multa` decimal(10,2) NOT NULL DEFAULT 0.00,
  `multa_paga` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `emprestimos`
--

INSERT INTO `emprestimos` (`id`, `usuario_id`, `livro_id`, `data_emprestimo`, `data_devolucao_prevista`, `data_devolucao_real`, `status`, `multa`, `multa_paga`) VALUES
(1, 1, 2, '2025-11-11 13:58:52', '2025-11-12', '2025-11-11', 'devolvido', 0.00, 0),
(2, 1, 2, '2025-11-11 14:01:55', '2025-11-19', '2025-11-11', 'devolvido', 0.00, 0),
(3, 2, 2, '2025-11-11 14:06:28', '2025-11-20', '2025-11-11', 'devolvido', 0.00, 0),
(4, 2, 3, '2025-11-11 14:07:27', '2025-11-12', NULL, 'ativo', 0.00, 0),
(5, 1, 3, '2025-11-11 14:07:55', '2025-11-13', '2025-11-11', 'devolvido', 0.00, 0),
(6, 2, 1, '2025-11-11 14:14:55', '2025-11-08', '2025-11-11', 'devolvido', 1.50, 1),
(7, 1, 3, '2025-11-11 14:15:13', '2025-11-09', '2025-11-11', 'devolvido', 1.00, 1),
(8, 2, 3, '2025-11-11 14:40:02', '2025-11-12', NULL, 'ativo', 0.00, 0),
(9, 2, 2, '2025-11-11 14:40:34', '2025-11-09', '2025-11-11', 'devolvido', 1.00, 1),
(10, 2, 2, '2025-11-11 14:44:09', '2025-11-12', NULL, 'ativo', 0.00, 0);

-- --------------------------------------------------------

--
-- Estrutura para tabela `livros`
--

CREATE TABLE `livros` (
  `id` int(11) NOT NULL,
  `titulo` varchar(150) NOT NULL,
  `autor` varchar(100) NOT NULL,
  `isbn` varchar(20) DEFAULT NULL,
  `ano` int(11) NOT NULL,
  `editora` varchar(100) NOT NULL,
  `categoria` varchar(50) DEFAULT NULL,
  `quantidade` int(11) DEFAULT 0,
  `quantidade_disponivel` int(11) DEFAULT 0,
  `descricao` text DEFAULT NULL,
  `paginas` int(11) NOT NULL,
  `genero` varchar(50) NOT NULL,
  `data_cadastro` timestamp NOT NULL DEFAULT current_timestamp(),
  `ativo` tinyint(1) DEFAULT 1,
  `status` enum('ativo','emprestado') DEFAULT 'ativo'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `livros`
--

INSERT INTO `livros` (`id`, `titulo`, `autor`, `isbn`, `ano`, `editora`, `categoria`, `quantidade`, `quantidade_disponivel`, `descricao`, `paginas`, `genero`, `data_cadastro`, `ativo`, `status`) VALUES
(1, 'O Pequeno Príncipe', 'Antoine de Saint-Exupéry', '978-0156012195', 0, '', 'Ficção', 3, 3, 'Um clássico da literatura infantil', 85, 'FICÇÃO', '2025-11-11 13:32:14', 1, 'ativo'),
(2, 'Dom Casmurro', 'Machado de Assis', '978-8535934633', 0, '', 'Romance', 2, 1, 'Uma das obras-primas da literatura brasileira', 72, 'ROMANCE', '2025-11-11 13:32:14', 1, 'emprestado'),
(3, '1984', 'George Orwell', '978-0451524935', 0, '', 'Ficção Científica', 2, 0, 'Distopia futurista clássica', 48, 'FICÇÃO', '2025-11-11 13:32:14', 1, 'emprestado');

-- --------------------------------------------------------

--
-- Estrutura para tabela `multas_pagamentos`
--

CREATE TABLE `multas_pagamentos` (
  `id` int(11) NOT NULL,
  `emprestimo_id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `metodo_pagamento` varchar(50) DEFAULT NULL,
  `admin_id` int(11) DEFAULT NULL,
  `data_pagamento` timestamp NOT NULL DEFAULT current_timestamp(),
  `observacoes` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `multas_pagamentos`
--

INSERT INTO `multas_pagamentos` (`id`, `emprestimo_id`, `usuario_id`, `valor`, `metodo_pagamento`, `admin_id`, `data_pagamento`, `observacoes`) VALUES
(1, 7, 1, 1.00, 'presencial', 0, '2025-11-11 14:36:29', NULL),
(2, 6, 2, 1.50, 'presencial', 0, '2025-11-11 14:43:56', NULL),
(3, 9, 2, 1.00, 'presencial', 0, '2025-11-11 14:43:58', NULL);

-- --------------------------------------------------------

--
-- Estrutura para tabela `reservas`
--

CREATE TABLE `reservas` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `livro_id` int(11) NOT NULL,
  `data_reserva` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('ativa','cancelada','convertida') DEFAULT 'ativa'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `reservas`
--

INSERT INTO `reservas` (`id`, `usuario_id`, `livro_id`, `data_reserva`, `status`) VALUES
(1, 1, 3, '2025-11-11 14:14:00', 'convertida');

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `tipo_usuario` varchar(20) DEFAULT NULL,
  `nome` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `cpf` varchar(11) DEFAULT NULL,
  `matricula` varchar(20) DEFAULT NULL,
  `senha` varchar(255) NOT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `endereco` text DEFAULT NULL,
  `bairro` varchar(100) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT NULL,
  `uf` varchar(2) DEFAULT NULL,
  `foto` varchar(255) DEFAULT NULL,
  `data_cadastro` timestamp NOT NULL DEFAULT current_timestamp(),
  `ativo` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`id`, `tipo_usuario`, `nome`, `email`, `cpf`, `matricula`, `senha`, `telefone`, `endereco`, `bairro`, `cidade`, `uf`, `foto`, `data_cadastro`, `ativo`) VALUES
(1, 'admin', 'Admin', 'admin@biblioteca.com', '00000000000', '001', '$2y$10$A/tD2HqnVGIQpLvTzVEVvunQRTHlUvaM96vBK/jjxC642a2gtSUti', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-11 13:58:37', 1),
(2, 'admin', 'MAXIMIANO EDUARDO PEREIRA', 'max@netminas.com', '04587216623', '1', '$2y$10$s0rqFYgE92gpqctPA.NOv.6uj.xYjb7VYPU0pZZ6CPgdol4ky.MnG', NULL, 'AVE', 'BAIRRO', 'UBERLANDIA', 'MG', '691342cc58355.png', '2025-11-11 14:06:04', 1);

-- --------------------------------------------------------

--
-- Estrutura stand-in para view `usuarios_com_debito`
-- (Veja abaixo para a visão atual)
--
CREATE TABLE `usuarios_com_debito` (
`usuario_id` int(11)
);

-- --------------------------------------------------------

--
-- Estrutura para view `usuarios_com_debito`
--
DROP TABLE IF EXISTS `usuarios_com_debito`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `usuarios_com_debito`  AS SELECT DISTINCT `emprestimos`.`usuario_id` AS `usuario_id` FROM `emprestimos` WHERE `emprestimos`.`multa` > 0 AND `emprestimos`.`multa_paga` = 0 ;

--
-- Índices para tabelas despejadas
--

--
-- Índices de tabela `emprestimos`
--
ALTER TABLE `emprestimos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD KEY `livro_id` (`livro_id`);

--
-- Índices de tabela `livros`
--
ALTER TABLE `livros`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `isbn` (`isbn`);

--
-- Índices de tabela `multas_pagamentos`
--
ALTER TABLE `multas_pagamentos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `emprestimo_id` (`emprestimo_id`),
  ADD KEY `usuario_id` (`usuario_id`);

--
-- Índices de tabela `reservas`
--
ALTER TABLE `reservas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `usuario_id` (`usuario_id`),
  ADD KEY `livro_id` (`livro_id`);

--
-- Índices de tabela `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `cpf` (`cpf`),
  ADD UNIQUE KEY `matricula` (`matricula`);

--
-- AUTO_INCREMENT para tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `emprestimos`
--
ALTER TABLE `emprestimos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT de tabela `livros`
--
ALTER TABLE `livros`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de tabela `multas_pagamentos`
--
ALTER TABLE `multas_pagamentos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de tabela `reservas`
--
ALTER TABLE `reservas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- Restrições para tabelas despejadas
--

--
-- Restrições para tabelas `emprestimos`
--
ALTER TABLE `emprestimos`
  ADD CONSTRAINT `emprestimos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `emprestimos_ibfk_2` FOREIGN KEY (`livro_id`) REFERENCES `livros` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `multas_pagamentos`
--
ALTER TABLE `multas_pagamentos`
  ADD CONSTRAINT `multas_pagamentos_ibfk_1` FOREIGN KEY (`emprestimo_id`) REFERENCES `emprestimos` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `multas_pagamentos_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `reservas`
--
ALTER TABLE `reservas`
  ADD CONSTRAINT `reservas_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `reservas_ibfk_2` FOREIGN KEY (`livro_id`) REFERENCES `livros` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
