<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';
requireAuth();

// Consulta totais com verificação de erro
$queryUsuarios = mysqli_query($conexao, "SELECT COUNT(*) AS total FROM usuarios");
if (!$queryUsuarios) {
    die("Erro na query de usuários: " . mysqli_error($conexao));
}
$totalUsuarios = mysqli_fetch_assoc($queryUsuarios)['total'];

$queryLivros = mysqli_query($conexao, "SELECT COUNT(*) AS total FROM livros");
if (!$queryLivros) {
    die("Erro na query de livros: " . mysqli_error($conexao));
}
$totalLivros = mysqli_fetch_assoc($queryLivros)['total'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel - Biblioteca Escolar</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .dashboard-card { transition: transform 0.2s ease-in-out; }
        .dashboard-card:hover { transform: scale(1.02); }
        .icon-box { width: 60px; height: 60px; background-color: rgba(0,0,0,0.05); display: flex; align-items: center; justify-content: center; border-radius: 50%; font-size: 1.5rem; }
    </style>
</head>
<body>
<div class="container mt-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Painel da Biblioteca</h1>
        <div class="d-flex gap-2">
            <?php $u = usuario_sessao(); ?>
            <span class="badge text-bg-light align-self-center">Olá, <?= htmlspecialchars($u['nome'] ?? 'Usuário') ?> (<?= htmlspecialchars($u['tipo_usuario']) ?>)</span>
            <a href="logout.php" class="btn btn-outline-secondary">
                <i class="bi bi-box-arrow-right me-1"></i> Sair
            </a>
        </div>
    </div>

    <!-- Painéis -->
    <div class="row g-4 mb-4">
        <?php if (isAdmin()): ?>
        <div class="col-md-6">
            <div class="card shadow dashboard-card">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-box me-3 text-primary">
                        <i class="bi bi-people-fill"></i>
                    </div>
                    <div>
                        <h5 class="card-title mb-1">Usuários Cadastrados</h5>
                        <h3 class="mb-0"><?= $totalUsuarios ?></h3>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-0 text-end">
                    <a href="listar_usuarios.php" class="btn btn-sm btn-primary">
                        <i class="bi bi-eye me-1"></i> Ver Usuários
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="col-md-6">
            <div class="card shadow dashboard-card">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-box me-3 text-success">
                        <i class="bi bi-book-half"></i>
                    </div>
                    <div>
                        <h5 class="card-title mb-1">Livros Registrados</h5>
                        <h3 class="mb-0"><?= $totalLivros ?></h3>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-0 text-end">
                    <a href="listar_livros.php" class="btn btn-sm btn-success">
                        <i class="bi bi-eye me-1"></i> Ver Livros
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Navegação adicional -->
    <div class="row g-3">
        <?php if (isAdmin()): ?>
        <div class="col-md-4">
            <a href="listar_usuarios.php" class="btn btn-outline-primary w-100 py-3">
                <i class="bi bi-person-gear me-2"></i> Gerenciar Usuários
            </a>
        </div>
        <?php endif; ?>
        <div class="col-md-4">
            <a href="listar_livros.php" class="btn btn-outline-success w-100 py-3">
                <i class="bi bi-journal-bookmark me-2"></i> Gerenciar Livros
            </a>
        </div>
        <div class="col-md-4">
            <a href="listar_emprestimos.php" class="btn btn-outline-info w-100 py-3">
                <i class="bi bi-arrow-left-right me-2"></i> Empréstimos
            </a>
        </div>
        <div class="col-md-4">
            <a href="listar_reservas.php" class="btn btn-outline-warning w-100 py-3">
                <i class="bi bi-bookmark-plus me-2"></i> Reservas
            </a>
        </div>
        <div class="col-md-4">
            <a href="listar_atrasos.php" class="btn btn-outline-danger w-100 py-3">
                <i class="bi bi-exclamation-triangle me-2"></i> Atrasos
            </a>
        </div>
        <?php if (isAdmin()): ?>
        <div class="col-md-4">
            <a href="graficos.php" class="btn btn-outline-info w-100 py-3">
                <i class="bi bi-graph-up me-2"></i> Gráficos
            </a>
        </div>
        <?php endif; ?>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php mysqli_close($conexao); ?>
