<?php
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';
requireAdmin();

// Somente POST (formulário em listar_atrasos.php já usa method="post")
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: listar_atrasos.php');
    exit;
}

$emprestimo_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($emprestimo_id <= 0) {
    $_SESSION['mensagem_erro'] = "ID de empréstimo inválido.";
    header('Location: listar_atrasos.php');
    exit;
}

// ID do admin logado para registrar no histórico
$admin_id = isAdmin() ? ((int)($_SESSION['usuario_id'] ?? 0)) : 0;
$metodo = isset($_POST['metodo']) ? trim($_POST['metodo']) : 'presencial';

// Buscar empréstimo pendente
$stmt = $conexao->prepare("SELECT usuario_id, livro_id, multa, status FROM emprestimos WHERE id = ?");
$stmt->bind_param("i", $emprestimo_id);
$stmt->execute();
$emp = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$emp || $emp['status'] !== 'pendente_pagamento') {
    $_SESSION['mensagem_erro'] = "Empréstimo não encontrado ou não está pendente de pagamento.";
    header('Location: listar_atrasos.php');
    exit;
}

$usuario_id = (int) $emp['usuario_id'];
$livro_id = (int) $emp['livro_id'];
$valor = (float) $emp['multa'];

mysqli_begin_transaction($conexao);

try {
    // Inserir histórico de pagamento
    $ins = $conexao->prepare("INSERT INTO multas_pagamentos (emprestimo_id, usuario_id, valor, metodo_pagamento, admin_id) VALUES (?, ?, ?, ?, ?)");
    $ins->bind_param("iidsi", $emprestimo_id, $usuario_id, $valor, $metodo, $admin_id);
    if (!$ins->execute()) {
        throw new Exception("Erro ao inserir pagamento: " . $ins->error);
    }
    $ins->close();

    // Atualizar empréstimo: marcar multa paga e finalizar devolução
    $upd = $conexao->prepare("UPDATE emprestimos SET multa_paga = 1, status = 'devolvido' WHERE id = ?");
    $upd->bind_param("i", $emprestimo_id);
    if (!$upd->execute()) {
        throw new Exception("Erro ao atualizar empréstimo: " . $upd->error);
    }
    $upd->close();

    // Atualizar livro: aumentar quantidade disponível e definir status
    $u2 = $conexao->prepare("UPDATE livros SET quantidade_disponivel = quantidade_disponivel + 1, status = 'ativo' WHERE id = ?");
    $u2->bind_param("i", $livro_id);
    if (!$u2->execute()) {
        throw new Exception("Erro ao atualizar livro: " . $u2->error);
    }
    $u2->close();

    mysqli_commit($conexao);

    $_SESSION['mensagem_sucesso'] = "Multa marcada como paga e devolução finalizada.";
} catch (Exception $ex) {
    mysqli_rollback($conexao);
    $_SESSION['mensagem_erro'] = $ex->getMessage();
}

header('Location: listar_atrasos.php');
exit;
?>