<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';

// Se já estiver logado, vá direto ao painel
if (usuario_logado()) {
    header('Location: principal.php');
    exit;
}

$erro = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email_input = trim($_POST['email'] ?? '');
    $senha = $_POST['senha'] ?? '';

    if ($email_input === '' || $senha === '') {
        $erro = 'Informe email e senha.';
    } else {
        // Buscar usuário por email
        $stmt = $conexao->prepare("SELECT id, nome, matricula, senha, tipo_usuario, email FROM usuarios WHERE email = ? LIMIT 1");
        if ($stmt) {
            $stmt->bind_param('s', $email_input);
            $stmt->execute();
            $res = $stmt->get_result();
            $user = $res->fetch_assoc();
            $stmt->close();

            if ($user && password_verify($senha, $user['senha'])) {
                $email = $user['email'] ?: ($user['matricula'] . '@local');
                usuario_definir_sessao((int)$user['id'], (string)$user['nome'], (string)$email, (string)($user['tipo_usuario'] ?: 'usuario'));
                header('Location: principal.php');
                exit;
            } else {
                $erro = 'Credenciais inválidas.';
            }
        } else {
            $erro = 'Erro ao preparar consulta.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login - Biblioteca</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height: 100vh;">
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm">
                <div class="card-body p-4">
                    <h3 class="mb-3 text-center">Acesso à Biblioteca</h3>
                    <?php if ($erro): ?>
                        <div class="alert alert-danger" role="alert"><?= htmlspecialchars($erro) ?></div>
                    <?php endif; ?>
                    <form method="post" novalidate>
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Senha</label>
                            <input type="password" name="senha" class="form-control" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Entrar</button>
                        </div>
                    </form>
                </div>
            </div>
            <p class="text-center mt-3 small text-muted">Use seu email e senha cadastrados.</p>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
