<?php
// Arquivo: listar_usuarios.php
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';
requireAdmin();

// Processa edição de usuário (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['form_tipo']) && $_POST['form_tipo'] === 'editar_usuario') {
    $id = (int) $_POST['id_usuario'];
    $nome = mysqli_real_escape_string($conexao, $_POST['nome']);
    $cpf = mysqli_real_escape_string($conexao, $_POST['cpf']);
    $matricula = mysqli_real_escape_string($conexao, $_POST['matricula']);
    $email = mysqli_real_escape_string($conexao, $_POST['email']);
    $endereco = mysqli_real_escape_string($conexao, $_POST['endereco']);
    $bairro = mysqli_real_escape_string($conexao, $_POST['bairro']);
    $cidade = mysqli_real_escape_string($conexao, $_POST['cidade']);
    $uf = mysqli_real_escape_string($conexao, $_POST['uf']);
    $tipo_usuario = mysqli_real_escape_string($conexao, $_POST['tipo_usuario'] ?? 'usuario');
    $senha_nova = trim($_POST['senha'] ?? '');

    $setSenha = '';
    if ($senha_nova !== '') {
        $hash = password_hash($senha_nova, PASSWORD_DEFAULT);
        $setSenha = ", senha = '" . mysqli_real_escape_string($conexao, $hash) . "'";
    }

    $sql = "UPDATE usuarios SET nome='$nome', cpf='$cpf', matricula='$matricula', email='$email', endereco='$endereco', bairro='$bairro', cidade='$cidade', uf='$uf', tipo_usuario='$tipo_usuario' $setSenha WHERE id=$id";

    if (mysqli_query($conexao, $sql)) {
        $_SESSION['mensagem_sucesso'] = "Usuário atualizado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao atualizar: " . mysqli_error($conexao);
    }

    header('Location: listar_usuarios.php');
    exit();
}

// Processa cadastro de novo usuário (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['form_tipo']) && $_POST['form_tipo'] === 'novo_usuario') {
    $nome = mysqli_real_escape_string($conexao, $_POST['nome']);
    $cpf = mysqli_real_escape_string($conexao, $_POST['cpf']);
    $matricula = mysqli_real_escape_string($conexao, $_POST['matricula']);
    $email = mysqli_real_escape_string($conexao, $_POST['email']);
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $endereco = mysqli_real_escape_string($conexao, $_POST['endereco']);
    $bairro = mysqli_real_escape_string($conexao, $_POST['bairro']);
    $cidade = mysqli_real_escape_string($conexao, $_POST['cidade']);
    $uf = mysqli_real_escape_string($conexao, $_POST['uf']);
    $tipo_usuario = mysqli_real_escape_string($conexao, $_POST['tipo_usuario'] ?? 'usuario');

    $nome_foto = null;
    if (!empty($_FILES['foto']['name'])) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $nome_foto = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], 'uploads/' . $nome_foto);
    }

    $sql = "INSERT INTO usuarios (nome, cpf, matricula, email, senha, endereco, bairro, cidade, uf, foto, tipo_usuario)
            VALUES ('$nome', '$cpf', '$matricula', '$email', '$senha', '$endereco', '$bairro', '$cidade', '$uf', '$nome_foto', '$tipo_usuario')";

    if (mysqli_query($conexao, $sql)) {
        $_SESSION['mensagem_sucesso'] = "Usuário cadastrado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao cadastrar: " . mysqli_error($conexao);
    }

    header('Location: listar_usuarios.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Dashboard de Usuários</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        .user-photo {
            width: 50px;
            height: 50px;
            object-fit: cover;
        }
    </style>
</head>
<body>

<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Usuários da Biblioteca</h1>
        <div>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                <i class="bi bi-plus-circle me-2"></i>Adicionar Usuário
            </button>
            <a href="index.php" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Voltar
            </a>
        </div>
    </div>

    <?php
    if (isset($_SESSION['mensagem_sucesso'])) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_sucesso'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_sucesso']);
    }
    if (isset($_SESSION['mensagem_erro'])) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_erro'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_erro']);
    }
    ?>

    <div class="table-responsive">
        <table class="table table-striped table-hover align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Foto</th>
                    <th>ID</th>
                    <th>Nome</th>
                    <th>CPF</th>
                    <th>Matrícula</th>
                    <th>Tipo</th>
                    <th class="text-center">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT * FROM usuarios ORDER BY nome ASC";
                $resultado = mysqli_query($conexao, $sql);

                if (mysqli_num_rows($resultado) > 0) {
                    while ($usuario = mysqli_fetch_assoc($resultado)) {
                        $foto_caminho = 'https://placehold.co/50x50/EFEFEF/AAAAAA&text=...';
                        if (!empty($usuario['foto']) && file_exists('uploads/' . $usuario['foto'])) {
                            $foto_caminho = 'uploads/' . $usuario['foto'];
                        }
                        ?>
                        <tr>
                            <td><img src="<?= htmlspecialchars($foto_caminho) ?>" alt="Foto de <?= htmlspecialchars($usuario['nome']) ?>" class="rounded-circle user-photo"></td>
                            <td><?= htmlspecialchars($usuario['id']) ?></td>
                            <td><?= htmlspecialchars($usuario['nome']) ?></td>
                            <td><?= htmlspecialchars($usuario['cpf']) ?></td>
                            <td><?= htmlspecialchars($usuario['matricula']) ?></td>
                            <td><span class="badge <?= ($usuario['tipo_usuario'] === 'admin' ? 'bg-primary' : 'bg-secondary') ?>"><?= htmlspecialchars($usuario['tipo_usuario'] ?? 'usuario') ?></span></td>
                            <td class="text-center">
                                <button class="btn btn-info btn-sm" title="Visualizar"
                                        data-bs-toggle="modal"
                                        data-bs-target="#viewModal"
                                        data-id="<?= $usuario['id'] ?>"
                                        data-nome="<?= htmlspecialchars($usuario['nome']) ?>"
                                        data-foto="<?= htmlspecialchars($foto_caminho) ?>">
                                    <i class="bi bi-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-sm" title="Editar"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editUserModal"
                                        data-id="<?= $usuario['id'] ?>"
                                        data-nome="<?= htmlspecialchars($usuario['nome']) ?>"
                                        data-cpf="<?= htmlspecialchars($usuario['cpf']) ?>"
                                        data-matricula="<?= htmlspecialchars($usuario['matricula']) ?>"
                                        data-email="<?= htmlspecialchars($usuario['email']) ?>"
                                        data-endereco="<?= htmlspecialchars($usuario['endereco']) ?>"
                                        data-bairro="<?= htmlspecialchars($usuario['bairro']) ?>"
                                        data-cidade="<?= htmlspecialchars($usuario['cidade']) ?>"
                                        data-uf="<?= htmlspecialchars($usuario['uf']) ?>"
                                        data-tipo="<?= htmlspecialchars($usuario['tipo_usuario'] ?? 'usuario') ?>">
                                    <i class="bi bi-pencil-square"></i>
                                </button>
                                <a href="excluir_usuario.php?id=<?= $usuario['id'] ?>" class="btn btn-danger btn-sm" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este usuário?');">
                                    <i class="bi bi-trash3"></i>
                                </a>
                            </td>
                        </tr>
                        <?php
                    }
                } else {
                    echo "<tr><td colspan='6' class='text-center'>Nenhum usuário encontrado.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Adicionar -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adicionar Novo Usuário</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form action="listar_usuarios.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="form_tipo" value="novo_usuario">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome:</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>
                    <div class="mb-3">
                        <label for="cpf" class="form-label">CPF:</label>
                        <input type="text" class="form-control" name="cpf" required pattern="\d{11}" title="Apenas números, 11 dígitos.">
                    </div>
                    <div class="mb-3">
                        <label for="matricula" class="form-label">Matrícula:</label>
                        <input type="text" class="form-control" name="matricula" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">E-mail:</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="senha" class="form-label">Senha:</label>
                        <input type="password" class="form-control" name="senha" minlength="6" required placeholder="Defina a senha do usuário">
                        <div class="form-text">Mínimo de 6 caracteres.</div>
                    </div>
                    <div class="mb-3">
                        <label for="endereco" class="form-label">Endereço:</label>
                        <input type="text" class="form-control" name="endereco" required>
                    </div>
                    <div class="mb-3">
                        <label for="bairro" class="form-label">Bairro:</label>
                        <input type="text" class="form-control" name="bairro" required>
                    </div>
                    <div class="mb-3">
                        <label for="cidade" class="form-label">Cidade:</label>
                        <input type="text" class="form-control" name="cidade" required>
                    </div>
                    <div class="mb-3">
                        <label for="uf" class="form-label">UF:</label>
                        <select name="uf" class="form-select" required>
                            <option value="">Selecione</option>
                            <?php
                            $ufs = ['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'];
                            foreach ($ufs as $uf) echo "<option value=\"$uf\">$uf</option>";
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="foto" class="form-label">Foto (opcional):</label>
                        <input type="file" class="form-control" name="foto" accept="image/*">
                    </div>
                    <div class="mb-3">
                        <label for="tipo_usuario" class="form-label">Tipo de Usuário</label>
                        <select name="tipo_usuario" class="form-select" required>
                            <option value="usuario" selected>Usuário</option>
                            <option value="admin">Administrador</option>
                        </select>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-success">Cadastrar Usuário</button>
                    </div>
                    <small class="text-muted d-block mt-2">A senha será armazenada de forma segura (hash) e poderá ser alterada depois com o gerador de hash.</small>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Usuário -->
<div class="modal fade" id="editUserModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Usuário</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="POST">
                    <input type="hidden" name="form_tipo" value="editar_usuario">
                    <input type="hidden" name="id_usuario" id="edit_id_usuario">
                    <div class="mb-3">
                        <label class="form-label">Nome</label>
                        <input type="text" class="form-control" name="nome" id="edit_nome" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">CPF</label>
                        <input type="text" class="form-control" name="cpf" id="edit_cpf" required pattern="\d{11}" title="Apenas números, 11 dígitos.">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Matrícula</label>
                        <input type="text" class="form-control" name="matricula" id="edit_matricula" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">E-mail</label>
                        <input type="email" class="form-control" name="email" id="edit_email" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nova Senha (opcional)</label>
                        <input type="password" class="form-control" name="senha" id="edit_senha" placeholder="Deixe em branco para manter a atual">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Endereço</label>
                        <input type="text" class="form-control" name="endereco" id="edit_endereco" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Bairro</label>
                        <input type="text" class="form-control" name="bairro" id="edit_bairro" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cidade</label>
                        <input type="text" class="form-control" name="cidade" id="edit_cidade" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">UF</label>
                        <select name="uf" id="edit_uf" class="form-select" required>
                            <?php $ufs = ['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'];
                            foreach ($ufs as $uf) echo "<option value=\"$uf\">$uf</option>"; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tipo de Usuário</label>
                        <select name="tipo_usuario" id="edit_tipo_usuario" class="form-select" required>
                            <option value="usuario">Usuário</option>
                            <option value="admin">Administrador</option>
                        </select>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Visualizar -->
<div class="modal fade" id="viewModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content text-center">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Usuário</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <img id="viewUserPhoto" src="" class="rounded-circle mb-3" style="width: 100px; height: 100px; object-fit: cover;">
                <p><strong>ID:</strong> <span id="viewUserId"></span></p>
                <p><strong>Nome:</strong> <span id="viewUserName"></span></p>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
const viewModal = document.getElementById('viewModal');
viewModal.addEventListener('show.bs.modal', event => {
    const button = event.relatedTarget;
    const id = button.getAttribute('data-id');
    const nome = button.getAttribute('data-nome');
    const foto = button.getAttribute('data-foto');

    viewModal.querySelector('#viewUserId').textContent = id;
    viewModal.querySelector('#viewUserName').textContent = nome;
    viewModal.querySelector('#viewUserPhoto').src = foto;
});

// Preencher modal de edição
const editUserModal = document.getElementById('editUserModal');
editUserModal.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    document.getElementById('edit_id_usuario').value = btn.getAttribute('data-id');
    document.getElementById('edit_nome').value = btn.getAttribute('data-nome');
    document.getElementById('edit_cpf').value = btn.getAttribute('data-cpf');
    document.getElementById('edit_matricula').value = btn.getAttribute('data-matricula');
    document.getElementById('edit_email').value = btn.getAttribute('data-email');
    document.getElementById('edit_endereco').value = btn.getAttribute('data-endereco');
    document.getElementById('edit_bairro').value = btn.getAttribute('data-bairro');
    document.getElementById('edit_cidade').value = btn.getAttribute('data-cidade');
    document.getElementById('edit_uf').value = btn.getAttribute('data-uf');
    document.getElementById('edit_tipo_usuario').value = btn.getAttribute('data-tipo') || 'usuario';
    document.getElementById('edit_senha').value = '';
});
</script>

</body>
</html>
<?php mysqli_close($conexao); ?>
