<?php
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';
requireAuth();

// CADASTRAR NOVO LIVRO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_tipo'] === 'novo_livro') {
    $titulo = $_POST['titulo'];
    $autor = $_POST['autor'];
    $isbn = $_POST['isbn'];
    $editora = $_POST['editora'] ?? '';
    $ano = (int) ($_POST['ano'] ?? 0);
    $categoria = $_POST['categoria'];
    $quantidade = (int) $_POST['quantidade'];

    $nome_capa = null;
    if (!empty($_FILES['capa']['name'])) {
        $ext = pathinfo($_FILES['capa']['name'], PATHINFO_EXTENSION);
        $nome_capa = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['capa']['tmp_name'], 'uploads/' . $nome_capa);
    }

    $stmt = $conexao->prepare("INSERT INTO livros (titulo, autor, isbn, categoria, quantidade, capa) 
                              VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssiss", $titulo, $autor, $isbn, $categoria, $quantidade, $nome_capa);
    
    if ($stmt->execute()) {
        $_SESSION['mensagem_sucesso'] = "Livro cadastrado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao cadastrar: " . $stmt->error;
    }
    $stmt->close();

    header('Location: listar_livros.php');
    exit();
}

// ATUALIZAR LIVRO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_tipo'] === 'editar_livro') {
    $id = (int) $_POST['id_livro'];
    $titulo = $_POST['titulo'];
    $autor = $_POST['autor'];
    $isbn = $_POST['isbn'];
    $categoria = $_POST['categoria'];
    $quantidade = (int) $_POST['quantidade'];

    $nome_capa = null;
    if (!empty($_FILES['capa']['name'])) {
        $ext = pathinfo($_FILES['capa']['name'], PATHINFO_EXTENSION);
        $nome_capa = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['capa']['tmp_name'], 'uploads/' . $nome_capa);
    }

    if ($nome_capa) {
        $stmt = $conexao->prepare("UPDATE livros SET titulo=?, autor=?, isbn=?, categoria=?, quantidade=?, capa=? WHERE id=?");
        $stmt->bind_param("sssissi", $titulo, $autor, $isbn, $categoria, $quantidade, $nome_capa, $id);
    } else {
        $stmt = $conexao->prepare("UPDATE livros SET titulo=?, autor=?, isbn=?, categoria=?, quantidade=? WHERE id=?");
        $stmt->bind_param("sssssi", $titulo, $autor, $isbn, $categoria, $quantidade, $id);
    }

    if ($stmt->execute()) {
        $_SESSION['mensagem_sucesso'] = "Livro atualizado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao atualizar: " . $stmt->error;
    }
    $stmt->close();

    header('Location: listar_livros.php');
    exit();
}

// EXCLUIR LIVRO
if (isset($_GET['excluir'])) {
    $id = (int) $_GET['excluir'];
    $stmt = $conexao->prepare("DELETE FROM livros WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $_SESSION['mensagem_sucesso'] = "Livro excluído com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao excluir: " . $stmt->error;
    }
    $stmt->close();
    
    header('Location: listar_livros.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Controle de Livros</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .book-cover {
            width: 50px;
            height: 70px;
            object-fit: cover;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Livros da Biblioteca</h1>
        <div>
            <?php if (isAdmin()): ?>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBookModal">
                <i class="bi bi-plus-circle me-2"></i>Adicionar Livro
            </button>
            <?php endif; ?>
            <a href="index.php" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Voltar
            </a>
        </div>
    </div>

    <?php
    if (isset($_SESSION['mensagem_sucesso'])) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_sucesso'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_sucesso']);
    }
    if (isset($_SESSION['mensagem_erro'])) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_erro'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_erro']);
    }
    ?>

    <div class="table-responsive">
        <table class="table table-striped table-hover align-middle">
            <thead class="table-dark">
            <tr>
                <th>Capa</th>
                <th>ID</th>
                <th>Título</th>
                <th>Autor</th>
                <th>ISBN</th>
                <th>Exemplares</th>
                <th class="text-center">Ações</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $sql = "SELECT * FROM livros ORDER BY titulo ASC";
            $resultado = mysqli_query($conexao, $sql);

            if (mysqli_num_rows($resultado) > 0) {
                while ($livro = mysqli_fetch_assoc($resultado)) {
                    $capa = !empty($livro['capa']) && file_exists('uploads/' . $livro['capa']) ?
                        'uploads/' . $livro['capa'] : 'https://placehold.co/50x70?text=Livro';
                    
                    // Verificar se está emprestado
                    $status_class = $livro['quantidade_disponivel'] <= 0 ? 'table-danger' : '';
                    $status_badge = $livro['quantidade_disponivel'] <= 0 ? 
                        '<span class="badge bg-danger ms-2"><i class="bi bi-lock"></i> Indisponível</span>' : 
                        '<span class="badge bg-success ms-2"><i class="bi bi-check-circle"></i> Disponível</span>';
                    ?>
                    <tr class="<?= $status_class ?>">
                        <td><img src="<?= $capa ?>" class="book-cover" alt="Capa"></td>
                        <td><?= $livro['id'] ?></td>
                        <td><?= htmlspecialchars($livro['titulo']) ?></td>
                        <td><?= htmlspecialchars($livro['autor']) ?></td>
                        <td><?= htmlspecialchars($livro['isbn']) ?></td>
                        <td>
                            <?= $livro['quantidade_disponivel'] ?>/<?= $livro['quantidade'] ?>
                            <?= $status_badge ?>
                        </td>
                        <td class="text-center">
                            <button class="btn btn-info btn-sm" title="Visualizar" data-bs-toggle="modal"
                                    data-bs-target="#viewBookModal"
                                    data-titulo="<?= htmlspecialchars($livro['titulo']) ?>"
                                    data-autor="<?= htmlspecialchars($livro['autor']) ?>"
                                    data-isbn="<?= htmlspecialchars($livro['isbn']) ?>"
                                    data-capa="<?= $capa ?>">
                                <i class="bi bi-eye"></i>
                            </button>
                            <?php if (isAdmin()): ?>
                            <button class="btn btn-warning btn-sm" title="Editar" data-bs-toggle="modal"
                                    data-bs-target="#editBookModal"
                                    data-id="<?= $livro['id'] ?>"
                                    data-titulo="<?= htmlspecialchars($livro['titulo']) ?>"
                                    data-autor="<?= htmlspecialchars($livro['autor']) ?>"
                                    data-isbn="<?= htmlspecialchars($livro['isbn']) ?>"
                                    data-categoria="<?= htmlspecialchars($livro['categoria']) ?>"
                                    data-quantidade="<?= $livro['quantidade'] ?>">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                            <a href="?excluir=<?= $livro['id'] ?>" class="btn btn-danger btn-sm"
                               onclick="return confirm('Tem certeza que deseja excluir este livro?')">
                                <i class="bi bi-trash3"></i>
                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                echo "<tr><td colspan='7' class='text-center'>Nenhum livro encontrado.</td></tr>";
            }
            ?>
            </tbody>
        </table>
    </div>
</div>

<!-- MODAL: ADICIONAR -->
<?php if (isAdmin()): ?>
<div class="modal fade" id="addBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="form_tipo" value="novo_livro">
                <div class="modal-header">
                    <h5 class="modal-title">Cadastrar Livro</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <?php
                    $campos = [
                        'titulo' => 'Título',
                        'autor' => 'Autor',
                        'isbn' => 'ISBN',
                        'categoria' => 'Categoria',
                        'quantidade' => 'Quantidade',
                    ];
                    foreach ($campos as $name => $label) {
                        echo "<div class='mb-3'>
                                <label class='form-label'>$label:</label>
                                <input type='" . ($name === 'quantidade' ? 'number' : 'text') . "' 
                                       name='$name' class='form-control' required>
                              </div>";
                    }
                    ?>
                    <div class="mb-3">
                        <label class="form-label">Capa (opcional):</label>
                        <input type="file" name="capa" class="form-control" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Salvar Livro</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- MODAL: VISUALIZAR -->
<div class="modal fade" id="viewBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content text-center">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Livro</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <img id="viewCapa" src="" class="rounded mb-3" style="width: 100px; height: 140px;">
                <p><strong>Título:</strong> <span id="viewTitulo"></span></p>
                <p><strong>Autor:</strong> <span id="viewAutor"></span></p>
                <p><strong>ISBN:</strong> <span id="viewISBN"></span></p>
            </div>
        </div>
    </div>
</div>

<!-- MODAL: EDITAR -->
<?php if (isAdmin()): ?>
<div class="modal fade" id="editBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="form_tipo" value="editar_livro">
                <input type="hidden" name="id_livro" id="editId">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Livro</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <?php
                    foreach ($campos as $name => $label) {
                        echo "<div class='mb-3'>
                                <label class='form-label'>$label:</label>
                                <input type='" . ($name === 'quantidade' ? 'number' : 'text') . "' 
                                       name='$name' id='edit_$name' class='form-control' required>
                              </div>";
                    }
                    ?>
                    <div class="mb-3">
                        <label class="form-label">Alterar Capa (opcional):</label>
                        <input type="file" name="capa" class="form-control" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Preencher modal de visualizar
const viewModal = document.getElementById('viewBookModal');
viewModal.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    document.getElementById('viewTitulo').textContent = btn.getAttribute('data-titulo');
    document.getElementById('viewAutor').textContent = btn.getAttribute('data-autor');
    document.getElementById('viewISBN').textContent = btn.getAttribute('data-isbn');
    document.getElementById('viewCapa').src = btn.getAttribute('data-capa');
});

// Preencher modal de editar
const editModal = document.getElementById('editBookModal');
editModal.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    document.getElementById('editId').value = btn.getAttribute('data-id');
    document.getElementById('edit_titulo').value = btn.getAttribute('data-titulo');
    document.getElementById('edit_autor').value = btn.getAttribute('data-autor');
    document.getElementById('edit_isbn').value = btn.getAttribute('data-isbn');
    document.getElementById('edit_categoria').value = btn.getAttribute('data-categoria');
    document.getElementById('edit_quantidade').value = btn.getAttribute('data-quantidade');
});
</script>
</body>
</html>
<?php mysqli_close($conexao); ?>
