<?php
session_start();
require_once 'config/config_bd.php';

// Registrar devolução (via GET) - mantém comportamento atual
if (isset($_GET['devolver'])) {
    $id = (int) $_GET['devolver'];

    // obter empréstimo ativo
    $stmt = $conexao->prepare("SELECT usuario_id, livro_id, data_devolucao_prevista FROM emprestimos WHERE id = ? AND status = 'ativo'");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $emp = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$emp) {
        $_SESSION['mensagem_erro'] = "Empréstimo não encontrado ou já finalizado.";
        header('Location: listar_atrasos.php'); exit;
    }

    $prevista = new DateTime($emp['data_devolucao_prevista']);
    $hoje = new DateTime();
    $dias_atraso = 0;
    if ($prevista < $hoje) {
        $dias_atraso = (int)$hoje->diff($prevista)->days;
    }
    $valor_multa = $dias_atraso * 0.50; // R$0,50 por dia

    if ($dias_atraso > 0) {
        // registrar multa e aguardar pagamento pelo admin
        $upd = $conexao->prepare("UPDATE emprestimos SET multa = ?, multa_paga = 0, status = 'pendente_pagamento', data_devolucao_real = NOW() WHERE id = ?");
        $upd->bind_param("di", $valor_multa, $id);
        $upd->execute();
        $upd->close();

        $_SESSION['mensagem_sucesso'] = "Devolução registrada com atraso. Multa de R$ " . number_format($valor_multa,2,',','.') . " pendente. Aguarde confirmação de pagamento pelo administrador.";
    } else {
        // sem atraso: finalizar devolução normalmente
        $upd = $conexao->prepare("UPDATE emprestimos SET status = 'devolvido', data_devolucao_real = NOW() WHERE id = ?");
        $upd->bind_param("i", $id);
        $upd->execute();
        $upd->close();

        // atualizar livro
        $u2 = $conexao->prepare("UPDATE livros SET quantidade_disponivel = quantidade_disponivel + 1, status = 'ativo' WHERE id = ?");
        $u2->bind_param("i", $emp['livro_id']);
        $u2->execute();
        $u2->close();

        $_SESSION['mensagem_sucesso'] = "Devolução registrada com sucesso.";
    }

    header('Location: listar_atrasos.php');
    exit();
}

// Buscar empréstimos em atraso OU pendentes de pagamento
$sql = "SELECT e.*, u.nome AS usuario_nome, l.titulo AS livro_titulo
        FROM emprestimos e
        JOIN usuarios u ON e.usuario_id = u.id
        JOIN livros l ON e.livro_id = l.id
        WHERE (e.status = 'ativo' AND DATE(e.data_devolucao_prevista) < CURDATE())
           OR e.status = 'pendente_pagamento'
        ORDER BY e.data_devolucao_prevista ASC";
$result = mysqli_query($conexao, $sql);
if (!$result) {
    die("Erro na query: " . mysqli_error($conexao));
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Atrasos - Biblioteca</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Atrasos</h1>
        <div>
            <a href="index.php" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Voltar
            </a>
        </div>
    </div>

    <?php if (isset($_SESSION['mensagem_sucesso'])): ?>
        <div class="alert alert-success"><?= $_SESSION['mensagem_sucesso']; ?></div>
        <?php unset($_SESSION['mensagem_sucesso']); endif; ?>
    <?php if (isset($_SESSION['mensagem_erro'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['mensagem_erro']; ?></div>
        <?php unset($_SESSION['mensagem_erro']); endif; ?>

    <div class="card shadow">
        <table class="table table-hover mb-0">
            <thead class="table-danger">
                <tr>
                    <th>ID</th>
                    <th>Usuário</th>
                    <th>Livro</th>
                    <th>Data Empréstimo</th>
                    <th>Prevista</th>
                    <th>Dias em Atraso</th>
                    <th>Multa</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
            <?php if (mysqli_num_rows($result) > 0): while ($e = mysqli_fetch_assoc($result)): 
                $prev = new DateTime($e['data_devolucao_prevista']);
                $hoje = new DateTime();
                $dias = 0;
                if ($prev < $hoje) $dias = (int)$hoje->diff($prev)->days;
                ?>
                <tr class="<?= $e['status'] === 'pendente_pagamento' ? 'table-warning' : 'table-danger' ?>">
                    <td><?= $e['id'] ?></td>
                    <td><?= htmlspecialchars($e['usuario_nome']) ?></td>
                    <td><?= htmlspecialchars($e['livro_titulo']) ?></td>
                    <td><?= date('d/m/Y', strtotime($e['data_emprestimo'])) ?></td>
                    <td><?= date('d/m/Y', strtotime($e['data_devolucao_prevista'])) ?></td>
                    <td><span class="badge bg-danger"><?= $dias ?></span></td>
                    <td>
                        <?php if ($e['status'] === 'pendente_pagamento'): ?>
                            <strong>R$ <?= number_format($e['multa'],2,',','.') ?></strong>
                        <?php else: ?>
                            <small class="text-muted">—</small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($e['status'] === 'pendente_pagamento'): ?>
                            <?php if (isAdmin()): ?>
                            <form method="post" action="marcar_multa_paga.php?id=<?= $e['id'] ?>" onsubmit="return confirm('Confirmar recebimento da multa e finalizar devolução?');" style="display:inline">
                                <input type="hidden" name="metodo" value="presencial">
                                <button type="submit" class="btn btn-sm btn-primary">
                                    <i class="bi bi-cash-stack"></i> Quitar Multa
                                </button>
                            </form>
                            <?php else: ?>
                                <small class="text-muted">Aguardando pagamento</small>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if (isAdmin()): ?>
                            <a href="?devolver=<?= $e['id'] ?>" class="btn btn-sm btn-success" onclick="return confirm('Registrar devolução deste empréstimo?')">
                                <i class="bi bi-check-circle"></i> Registrar Devolução
                            </a>
                            <?php else: ?>
                                <small class="text-muted">Sem ações</small>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; else: ?>
                <tr><td colspan="8" class="text-center py-3">Nenhum atraso encontrado.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php mysqli_close($conexao); ?>