<?php
// Funções utilitárias relacionadas a usuário/sessão/autorizações

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Garante que as chaves básicas existem na sessão
 */
function usuario_sessao(): array {
    return [
        'id' => $_SESSION['usuario_id'] ?? null,
        'nome' => $_SESSION['usuario_nome'] ?? null,
        'email' => $_SESSION['usuario_email'] ?? null,
        'tipo_usuario' => $_SESSION['tipo_usuario'] ?? 'usuario',
    ];
}

/**
 * Define dados do usuário logado na sessão. Use no login.
 */
function usuario_definir_sessao(int $id, string $nome, string $email, string $tipo_usuario = 'usuario'): void {
    $_SESSION['usuario_id'] = $id;
    $_SESSION['usuario_nome'] = $nome;
    $_SESSION['usuario_email'] = $email;
    $_SESSION['tipo_usuario'] = $tipo_usuario ?: 'usuario';
}

/**
 * True se há usuário logado
 */
function usuario_logado(): bool {
    return !empty($_SESSION['usuario_id']);
}

/**
 * True se usuário logado é admin
 */
function isAdmin(): bool {
    return (($_SESSION['tipo_usuario'] ?? 'usuario') === 'admin');
}

/**
 * Exige autenticação
 */
function requireAuth(): void {
    if (!usuario_logado()) {
        header('Location: login.php');
        exit;
    }
}

/**
 * Exige perfil administrador
 */
function requireAdmin(): void {
    requireAuth();
    if (!isAdmin()) {
        http_response_code(403);
        echo '<div style="font-family: Arial; padding: 2rem;">Acesso negado. Permissão insuficiente.</div>';
        exit;
    }
}

function usuario_tem_debito(mysqli $conexao, int $usuario_id): bool {
    $sql = "SELECT COUNT(*) AS cnt
            FROM emprestimos
            WHERE usuario_id = ?
              AND (
                    status = 'pendente_pagamento'
                    OR (status = 'ativo' AND DATE(data_devolucao_prevista) < CURDATE())
                    OR (multa > 0 AND multa_paga = 0)
                  )";
    $stmt = $conexao->prepare($sql);
    if (!$stmt) return true; // em dúvida, tratar como débito
    $stmt->bind_param('i', $usuario_id);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    return (isset($res['cnt']) && (int)$res['cnt'] > 0);
}
?>