<?php
// Página inicial pública da Biblioteca Escolar
// Se estiver logado, redireciona para o painel (principal.php)
session_start();
require_once __DIR__ . '/lib/usuario_utils.php';
if (function_exists('usuario_logado') && usuario_logado()) {
  header('Location: principal.php');
  exit;
}
?><!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Biblioteca Escolar - Escola Estadual Bueno Brandão</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    :root{
      --bg: #f7f9fc; --text: #1f2937; --muted: #6b7280; --primary: #0d6efd; --primary-hover: #0b5ed7;
      --card-bg: #ffffff; --shadow: 0 10px 25px rgba(0, 0, 0, 0.06); --radius: 16px; --maxw: 980px;
    }
    * { box-sizing: border-box; }
    html, body { height: 100%; margin: 0; font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,"Noto Sans",sans-serif; color: var(--text); background: linear-gradient(180deg,#f9fbff 0%,#f3f6fb 100%); }
    .page { min-height: 100%; display: grid; place-items: center; padding: 24px; }
    .card { width: 100%; max-width: var(--maxw); background: var(--card-bg); border-radius: var(--radius); box-shadow: var(--shadow); padding: clamp(20px, 4vw, 40px); }
    .logo-wrap { display: grid; place-items: center; width: 100%; }
    .logo { display: block; width: min(180px, 60vw); height: auto; object-fit: contain; filter: drop-shadow(0 3px 6px rgba(0,0,0,.08)); }
    h1 { margin: 20px 0 8px 0; font-size: clamp(1.25rem, 2.5vw + 1rem, 2rem); line-height: 1.2; text-align: center; }
    .subtitle { text-align: center; color: var(--muted); margin-bottom: 24px; font-size: clamp(.95rem, .6vw + .8rem, 1.05rem); }
    .intro { background: linear-gradient(180deg, #ffffff 0%, #fbfdff 100%); border: 1px solid #eef2f7; border-radius: 12px; padding: clamp(16px, 2vw, 20px); color: var(--text); line-height: 1.6; font-size: 1rem; margin: 16px 0 24px 0; }
    .intro p { margin: 0 0 10px 0; }
    .intro strong { font-weight: 600; }
    .photo-wrap { display: grid; place-items: center; margin: 8px 0 24px 0; }
    .school-photo { width: 100%; max-width: 820px; aspect-ratio: 16/9; object-fit: cover; border-radius: 12px; border: 1px solid #e9eef6; box-shadow: 0 12px 30px rgba(13, 110, 253, 0.09); background: #fff; }
    .actions { display: flex; gap: 12px; justify-content: center; flex-wrap: wrap; margin-top: 8px; }
    .btn { appearance: none; border: none; border-radius: 10px; padding: 12px 20px; font-size: 1rem; cursor: pointer; text-decoration: none; display: inline-flex; align-items: center; gap: 10px; transition: transform .08s ease, box-shadow .2s ease, background .2s ease; box-shadow: 0 6px 14px rgba(13, 110, 253, 0.18); user-select: none; }
    .btn:active { transform: translateY(1px); }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
    .btn-outline { background: transparent; color: var(--primary); border: 1px solid var(--primary); box-shadow: none; }
    .readme { color: var(--muted); text-decoration: none; font-weight: 500; }
    .readme:hover { text-decoration: underline; }
    @media (max-width: 520px) { .card { padding: 18px; } .intro { font-size: .98rem; } }
  </style>
</head>
<body>
  <main class="page">
    <section class="card" aria-label="Apresentação do Sistema de Biblioteca">
      <!-- Logo da escola -->
      <div class="logo-wrap">
        <img class="logo" src="uploads/logo.png" alt="Logo da Escola Estadual Bueno Brandão">
      </div>

      <!-- Título principal -->
      <h1>Sistema de Biblioteca – Escola Estadual Bueno Brandão</h1>
      <p class="subtitle">Projeto desenvolvido pelos alunos do curso técnico em Informática – Uberlândia/MG</p>

      <!-- Texto explicativo do projeto -->
      <div class="intro">
        <p>Este sistema foi desenvolvido pelos alunos do curso técnico em Informática da Escola Estadual Bueno Brandão, sob orientação da professora <strong>Graziele de Oliveira Pereira</strong>.</p>
        <p>O objetivo é aplicar na prática os conhecimentos adquiridos na disciplina, simulando o funcionamento de uma biblioteca escolar, com controle de usuários, livros e empréstimos.</p>
      </div>

      <!-- Foto da escola -->
      <div class="photo-wrap">
        <img class="school-photo" src="uploads/escola.png" alt="Foto da Escola Estadual Bueno Brandão">
      </div>

      <!-- Ações -->
      <div class="actions">
        <a class="btn btn-primary" href="login.php" aria-label="Acessar o sistema de biblioteca">Acessar Sistema</a>
        <a class="btn btn-outline readme" href="README.html" aria-label="Abrir documentação do projeto">Ver README</a>
      </div>
    </section>
  </main>
</body>
</html>