<?php
session_start();
require_once 'config/config_bd.php';
require_once 'lib/usuario_utils.php';
requireAdmin();

// Totais
$totalEmp = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS t FROM emprestimos"))['t'];
$totalUsuarios = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS t FROM usuarios"))['t'];
$totalLivros = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS t FROM livros"))['t'];

// Empréstimos últimos 12 meses
$months = [];
$counts = [];
$stmt = mysqli_query($conexao, "
    SELECT DATE_FORMAT(data_emprestimo, '%Y-%m') AS ym, COUNT(*) AS c
    FROM emprestimos
    WHERE data_emprestimo >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 11 MONTH),'%Y-%m-01')
    GROUP BY ym
    ORDER BY ym
");
$map = [];
while ($r = mysqli_fetch_assoc($stmt)) $map[$r['ym']] = (int)$r['c'];
// build last 12 months labels
for ($i = 11; $i >= 0; $i--) {
    $m = date('Y-m', strtotime("-{$i} months"));
    $months[] = date('M/Y', strtotime($m . "-01"));
    $counts[] = $map[$m] ?? 0;
}

// Top livros
$topBooksLabels = [];
$topBooksData = [];
$stmt = mysqli_query($conexao, "
    SELECT l.titulo, COUNT(*) AS c
    FROM emprestimos e
    JOIN livros l ON e.livro_id = l.id
    GROUP BY l.id
    ORDER BY c DESC
    LIMIT 10
");
while ($r = mysqli_fetch_assoc($stmt)) {
    $topBooksLabels[] = $r['titulo'];
    $topBooksData[] = (int)$r['c'];
}

// Top usuários
$topUsersLabels = [];
$topUsersData = [];
$stmt = mysqli_query($conexao, "
    SELECT u.nome, COUNT(*) AS c
    FROM emprestimos e
    JOIN usuarios u ON e.usuario_id = u.id
    GROUP BY u.id
    ORDER BY c DESC
    LIMIT 10
");
while ($r = mysqli_fetch_assoc($stmt)) {
    $topUsersLabels[] = $r['nome'];
    $topUsersData[] = (int)$r['c'];
}

// Status distribution
$statusLabels = [];
$statusData = [];
$stmt = mysqli_query($conexao, "SELECT status, COUNT(*) AS c FROM emprestimos GROUP BY status");
while ($r = mysqli_fetch_assoc($stmt)) {
    $statusLabels[] = $r['status'];
    $statusData[] = (int)$r['c'];
}

// Multas pendentes
$multi = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS qtd, COALESCE(SUM(multa),0) AS total FROM emprestimos WHERE multa_paga = 0 AND multa > 0"));
$qtdMultas = (int)$multi['qtd'];
$totalMultas = (float)$multi['total'];

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <title>Gráficos - Biblioteca</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Relatórios & Gráficos</h2>
        <a href="index.php" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Voltar</a>
    </div>

    <div class="row g-3 mb-3">
        <div class="col-md-3">
            <div class="card p-3">
                <h6>Total Empréstimos</h6>
                <h3><?= $totalEmp ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                <h6>Usuários</h6>
                <h3><?= $totalUsuarios ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                <h6>Livros</h6>
                <h3><?= $totalLivros ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                <h6>Multas Pendentes</h6>
                <h3>R$ <?= number_format($totalMultas,2,',','.') ?></h3>
                <small class="text-muted"><?= $qtdMultas ?> empréstimos</small>
            </div>
        </div>
    </div>

    <div class="row gy-4">
        <div class="col-lg-8">
            <div class="card p-3">
                <h6>Empréstimos (últimos 12 meses)</h6>
                <canvas id="chartMonthly" height="120"></canvas>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card p-3 mb-4">
                <h6>Distribuição por status</h6>
                <canvas id="chartStatus" height="200"></canvas>
            </div>

            <div class="card p-3">
                <h6>Top Usuários</h6>
                <canvas id="chartTopUsers" height="200"></canvas>
            </div>
        </div>

        <div class="col-12">
            <div class="card p-3">
                <h6>Top Livros emprestados</h6>
                <canvas id="chartTopBooks" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<script>
const months = <?= json_encode($months) ?>;
const monthlyData = <?= json_encode($counts) ?>;
const topBooksLabels = <?= json_encode($topBooksLabels) ?>;
const topBooksData = <?= json_encode($topBooksData) ?>;
const topUsersLabels = <?= json_encode($topUsersLabels) ?>;
const topUsersData = <?= json_encode($topUsersData) ?>;
const statusLabels = <?= json_encode($statusLabels) ?>;
const statusData = <?= json_encode($statusData) ?>;

// Monthly line
new Chart(document.getElementById('chartMonthly'), {
    type: 'line',
    data: {
        labels: months,
        datasets: [{
            label: 'Empréstimos',
            data: monthlyData,
            borderColor: '#0d6efd',
            backgroundColor: 'rgba(13,110,253,0.1)',
            fill: true,
            tension: 0.25
        }]
    },
    options: { responsive: true, plugins: { legend: { display: false } } }
});

// Status pie
new Chart(document.getElementById('chartStatus'), {
    type: 'pie',
    data: {
        labels: statusLabels,
        datasets: [{
            data: statusData,
            backgroundColor: ['#198754','#ffc107','#dc3545','#6c757d']
        }]
    },
    options: { responsive: true }
});

// Top users horizontal bar
new Chart(document.getElementById('chartTopUsers'), {
    type: 'bar',
    data: {
        labels: topUsersLabels,
        datasets: [{ label: 'Empréstimos', data: topUsersData, backgroundColor: '#0dcaf0' }]
    },
    options: { indexAxis: 'y', responsive: true, plugins: { legend: { display: false } } }
});

// Top books bar
new Chart(document.getElementById('chartTopBooks'), {
    type: 'bar',
    data: {
        labels: topBooksLabels,
        datasets: [{ label: 'Vezes emprestado', data: topBooksData, backgroundColor: '#6610f2' }]
    },
    options: { responsive: true, plugins: { legend: { display: false } } }
});
</script>
</body>
</html>