<?php
// Script independente para gerar hash de senha com password_hash
// Uso via navegador: abra /gerador_hash.php e informe a senha
// Uso via CLI: php gerador_hash.php "minha_senha"

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function gerar_hash(string $senha): string {
    $opcoes = [
        // Ajuste o custo conforme seu servidor (padrão 10). Custo maior = mais seguro, porém mais lento.
        'cost' => 10,
    ];
    return password_hash($senha, PASSWORD_DEFAULT, $opcoes);
}

// Modo CLI
if (php_sapi_name() === 'cli') {
    $senha = $argv[1] ?? '';
    if ($senha === '') {
        fwrite(STDERR, "Uso: php gerador_hash.php <senha>\n");
        exit(1);
    }
    $hash = gerar_hash($senha);
    fwrite(STDOUT, $hash . PHP_EOL);
    exit(0);
}

// Modo Web
$senha = $_POST['senha'] ?? '';
$hash = null;
$erro = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (trim($senha) === '') {
        $erro = 'Informe uma senha.';
    } else {
        $hash = gerar_hash($senha);
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerador de Hash de Senha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h3 class="mb-3">Gerador de Hash (password_hash)</h3>
                    <p class="text-muted small">Use este utilitário para gerar o hash BCrypt de uma senha. Copie o hash e utilize em sua tabela de usuários.</p>
                    <?php if ($erro): ?>
                        <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
                    <?php endif; ?>
                    <form method="post">
                        <div class="mb-3">
                            <label class="form-label">Senha</label>
                            <input type="text" name="senha" class="form-control" value="<?= htmlspecialchars($senha) ?>" required>
                        </div>
                        <div class="d-grid">
                            <button class="btn btn-primary" type="submit">Gerar Hash</button>
                        </div>
                    </form>
                    <?php if ($hash): ?>
                        <hr>
                        <div class="mb-2"><strong>Hash gerado:</strong></div>
                        <pre class="bg-body-secondary p-3 border rounded" style="word-wrap: break-word; white-space: pre-wrap;"><?= htmlspecialchars($hash) ?></pre>
                        <div class="alert alert-info small mb-0">
                            Exemplo de uso (MySQL):<br>
                            <code>UPDATE usuarios SET senha = '<?= htmlspecialchars($hash) ?>' WHERE email = 'email@dominio.com';</code>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <p class="text-center text-muted small mt-3">Também funciona via CLI: <code>php gerador_hash.php "minha_senha"</code></p>
        </div>
    </div>
</div>
</body>
</html>
