<?php
session_start();
require_once 'config/config_bd.php';

// Consulta totais
$totalUsuarios = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS total FROM usuarios"))['total'];
$totalLivros   = mysqli_fetch_assoc(mysqli_query($conexao, "SELECT COUNT(*) AS total FROM livros"))['total'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Administração da Biblioteca</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .dashboard-card {
            transition: transform 0.2s ease-in-out;
        }
        .dashboard-card:hover {
            transform: scale(1.02);
        }
        .icon-box {
            width: 60px;
            height: 60px;
            background-color: rgba(0,0,0,0.05);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-size: 1.5rem;
        }
    </style>
</head>
<body>
<div class="container mt-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Painel de Administração</h1>
        <a href="logout.php" class="btn btn-outline-secondary">
            <i class="bi bi-box-arrow-right me-1"></i> Sair
        </a>
    </div>

    <!-- Painéis -->
    <div class="row g-4 mb-4">
        <div class="col-md-6">
            <div class="card shadow dashboard-card">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-box me-3 text-primary">
                        <i class="bi bi-people-fill"></i>
                    </div>
                    <div>
                        <h5 class="card-title mb-1">Usuários Cadastrados</h5>
                        <h3 class="mb-0"><?= $totalUsuarios ?></h3>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-0 text-end">
                    <a href="listar_usuarios.php" class="btn btn-sm btn-primary">
                        <i class="bi bi-eye me-1"></i> Ver Usuários
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow dashboard-card">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-box me-3 text-success">
                        <i class="bi bi-book-half"></i>
                    </div>
                    <div>
                        <h5 class="card-title mb-1">Livros Registrados</h5>
                        <h3 class="mb-0"><?= $totalLivros ?></h3>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-0 text-end">
                    <a href="listar_livros.php" class="btn btn-sm btn-success">
                        <i class="bi bi-eye me-1"></i> Ver Livros
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Navegação adicional -->
    <div class="row g-3">
        <div class="col-md-6">
            <a href="listar_usuarios.php" class="btn btn-outline-primary w-100 py-3">
                <i class="bi bi-person-gear me-2"></i> Gerenciar Usuários
            </a>
        </div>
        <div class="col-md-6">
            <a href="listar_livros.php" class="btn btn-outline-success w-100 py-3">
                <i class="bi bi-journal-bookmark me-2"></i> Gerenciar Livros
            </a>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php mysqli_close($conexao); ?>
