<?php
session_start();
require_once 'config/config_bd.php';

// CADASTRAR NOVO LIVRO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_tipo'] === 'novo_livro') {
    $titulo = mysqli_real_escape_string($conexao, $_POST['titulo']);
    $autor = mysqli_real_escape_string($conexao, $_POST['autor']);
    $isbn = mysqli_real_escape_string($conexao, $_POST['isbn']);
    $editora = mysqli_real_escape_string($conexao, $_POST['editora']);
    $ano = (int) $_POST['ano'];
    $genero = mysqli_real_escape_string($conexao, $_POST['genero']);
    $paginas = (int) $_POST['paginas'];
    $quantidade = (int) $_POST['quantidade'];

    $nome_capa = null;
    if (!empty($_FILES['capa']['name'])) {
        $ext = pathinfo($_FILES['capa']['name'], PATHINFO_EXTENSION);
        $nome_capa = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['capa']['tmp_name'], 'uploads/' . $nome_capa);
    }

    $sql = "INSERT INTO livros (titulo, autor, isbn, editora, ano, genero, paginas, quantidade, capa)
            VALUES ('$titulo', '$autor', '$isbn', '$editora', $ano, '$genero', $paginas, $quantidade, '$nome_capa')";
    
    if (mysqli_query($conexao, $sql)) {
        $_SESSION['mensagem_sucesso'] = "Livro cadastrado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao cadastrar: " . mysqli_error($conexao);
    }

    header('Location: listar_livros.php');
    exit();
}

// ATUALIZAR LIVRO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['form_tipo'] === 'editar_livro') {
    $id = (int) $_POST['id_livro'];
    $titulo = mysqli_real_escape_string($conexao, $_POST['titulo']);
    $autor = mysqli_real_escape_string($conexao, $_POST['autor']);
    $isbn = mysqli_real_escape_string($conexao, $_POST['isbn']);
    $editora = mysqli_real_escape_string($conexao, $_POST['editora']);
    $ano = (int) $_POST['ano'];
    $genero = mysqli_real_escape_string($conexao, $_POST['genero']);
    $paginas = (int) $_POST['paginas'];
    $quantidade = (int) $_POST['quantidade'];

    $sql_capa = "";
    if (!empty($_FILES['capa']['name'])) {
        $ext = pathinfo($_FILES['capa']['name'], PATHINFO_EXTENSION);
        $nome_capa = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['capa']['tmp_name'], 'uploads/' . $nome_capa);
        $sql_capa = ", capa = '$nome_capa'";
    }

    $sql = "UPDATE livros SET 
                titulo = '$titulo',
                autor = '$autor',
                isbn = '$isbn',
                editora = '$editora',
                ano = $ano,
                genero = '$genero',
                paginas = $paginas,
                quantidade = $quantidade
                $sql_capa
            WHERE id_livro = $id";

    if (mysqli_query($conexao, $sql)) {
        $_SESSION['mensagem_sucesso'] = "Livro atualizado com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao atualizar: " . mysqli_error($conexao);
    }

    header('Location: listar_livros.php');
    exit();
}

// EXCLUIR LIVRO
if (isset($_GET['excluir'])) {
    $id = (int) $_GET['excluir'];
    $sql = "DELETE FROM livros WHERE id_livro = $id";
    if (mysqli_query($conexao, $sql)) {
        $_SESSION['mensagem_sucesso'] = "Livro excluído com sucesso!";
    } else {
        $_SESSION['mensagem_erro'] = "Erro ao excluir: " . mysqli_error($conexao);
    }
    header('Location: listar_livros.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Controle de Livros</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .book-cover {
            width: 50px;
            height: 70px;
            object-fit: cover;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="display-5">Livros da Biblioteca</h1>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBookModal">
            <i class="bi bi-plus-circle me-2"></i>Adicionar Livro
        </button>
    </div>

    <?php
    if (isset($_SESSION['mensagem_sucesso'])) {
        echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_sucesso'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_sucesso']);
    }
    if (isset($_SESSION['mensagem_erro'])) {
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
        echo $_SESSION['mensagem_erro'];
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['mensagem_erro']);
    }
    ?>

    <div class="table-responsive">
        <table class="table table-striped table-hover align-middle">
            <thead class="table-dark">
            <tr>
                <th>Capa</th>
                <th>ID</th>
                <th>Título</th>
                <th>Autor</th>
                <th>ISBN</th>
                <th>Exemplares</th>
                <th class="text-center">Ações</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $sql = "SELECT * FROM livros ORDER BY titulo ASC";
            $resultado = mysqli_query($conexao, $sql);

            if (mysqli_num_rows($resultado) > 0) {
                while ($livro = mysqli_fetch_assoc($resultado)) {
                    $capa = !empty($livro['capa']) && file_exists('uploads/' . $livro['capa']) ?
                        'uploads/' . $livro['capa'] : 'https://placehold.co/50x70?text=Livro';
                    ?>
                    <tr>
                        <td><img src="<?= $capa ?>" class="book-cover" alt="Capa"></td>
                        <td><?= $livro['id_livro'] ?></td>
                        <td><?= htmlspecialchars($livro['titulo']) ?></td>
                        <td><?= htmlspecialchars($livro['autor']) ?></td>
                        <td><?= htmlspecialchars($livro['isbn']) ?></td>
                        <td><?= $livro['quantidade'] ?></td>
                        <td class="text-center">
                            <button class="btn btn-info btn-sm" title="Visualizar" data-bs-toggle="modal"
                                    data-bs-target="#viewBookModal"
                                    data-titulo="<?= htmlspecialchars($livro['titulo']) ?>"
                                    data-autor="<?= htmlspecialchars($livro['autor']) ?>"
                                    data-isbn="<?= htmlspecialchars($livro['isbn']) ?>"
                                    data-capa="<?= $capa ?>">
                                <i class="bi bi-eye"></i>
                            </button>
                            <button class="btn btn-warning btn-sm" title="Editar" data-bs-toggle="modal"
                                    data-bs-target="#editBookModal"
                                    data-id="<?= $livro['id_livro'] ?>"
                                    data-titulo="<?= htmlspecialchars($livro['titulo']) ?>"
                                    data-autor="<?= htmlspecialchars($livro['autor']) ?>"
                                    data-isbn="<?= htmlspecialchars($livro['isbn']) ?>"
                                    data-editora="<?= htmlspecialchars($livro['editora']) ?>"
                                    data-ano="<?= $livro['ano'] ?>"
                                    data-genero="<?= htmlspecialchars($livro['genero']) ?>"
                                    data-paginas="<?= $livro['paginas'] ?>"
                                    data-quantidade="<?= $livro['quantidade'] ?>">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                            <a href="?excluir=<?= $livro['id_livro'] ?>" class="btn btn-danger btn-sm"
                               onclick="return confirm('Tem certeza que deseja excluir este livro?')">
                                <i class="bi bi-trash3"></i>
                            </a>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                echo "<tr><td colspan='7' class='text-center'>Nenhum livro encontrado.</td></tr>";
            }
            ?>
            </tbody>
        </table>
    </div>
</div>

<!-- MODAL: ADICIONAR -->
<div class="modal fade" id="addBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="form_tipo" value="novo_livro">
                <div class="modal-header">
                    <h5 class="modal-title">Cadastrar Livro</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <?php
                    $campos = [
                        'titulo' => 'Título',
                        'autor' => 'Autor',
                        'isbn' => 'ISBN',
                        'editora' => 'Editora',
                        'ano' => 'Ano',
                        'genero' => 'Gênero',
                        'paginas' => 'Páginas',
                        'quantidade' => 'Quantidade',
                    ];
                    foreach ($campos as $name => $label) {
                        echo "<div class='mb-3'>
                                <label class='form-label'>$label:</label>
                                <input type='" . (in_array($name, ['ano', 'paginas', 'quantidade']) ? 'number' : 'text') . "' 
                                       name='$name' class='form-control' required>
                              </div>";
                    }
                    ?>
                    <div class="mb-3">
                        <label class="form-label">Capa (opcional):</label>
                        <input type="file" name="capa" class="form-control" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Salvar Livro</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- MODAL: VISUALIZAR -->
<div class="modal fade" id="viewBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content text-center">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Livro</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <img id="viewCapa" src="" class="rounded mb-3" style="width: 100px; height: 140px;">
                <p><strong>Título:</strong> <span id="viewTitulo"></span></p>
                <p><strong>Autor:</strong> <span id="viewAutor"></span></p>
                <p><strong>ISBN:</strong> <span id="viewISBN"></span></p>
            </div>
        </div>
    </div>
</div>

<!-- MODAL: EDITAR -->
<div class="modal fade" id="editBookModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="form_tipo" value="editar_livro">
                <input type="hidden" name="id_livro" id="editId">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Livro</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <?php
                    foreach ($campos as $name => $label) {
                        echo "<div class='mb-3'>
                                <label class='form-label'>$label:</label>
                                <input type='" . (in_array($name, ['ano', 'paginas', 'quantidade']) ? 'number' : 'text') . "' 
                                       name='$name' id='edit_$name' class='form-control' required>
                              </div>";
                    }
                    ?>
                    <div class="mb-3">
                        <label class="form-label">Alterar Capa (opcional):</label>
                        <input type="file" name="capa" class="form-control" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Preencher modal de visualizar
const viewModal = document.getElementById('viewBookModal');
viewModal.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    document.getElementById('viewTitulo').textContent = btn.getAttribute('data-titulo');
    document.getElementById('viewAutor').textContent = btn.getAttribute('data-autor');
    document.getElementById('viewISBN').textContent = btn.getAttribute('data-isbn');
    document.getElementById('viewCapa').src = btn.getAttribute('data-capa');
});

// Preencher modal de editar
const editModal = document.getElementById('editBookModal');
editModal.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    const campos = ['id', 'titulo', 'autor', 'isbn', 'editora', 'ano', 'genero', 'paginas', 'quantidade'];
    campos.forEach(c => {
        const input = document.getElementById(`edit_${c}`) || document.getElementById(`edit${c.charAt(0).toUpperCase() + c.slice(1)}`);
        if (input) input.value = btn.getAttribute(`data-${c}`);
    });
});
</script>
</body>
</html>
<?php mysqli_close($conexao); ?>
